package com.digiwin.athena.semc.dto.news;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 新增/编辑公告校验 请求入参
 *
 * @author sunqgz
 * @since 2025-1-13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ValidSaveNewsTypeReqDTO implements Serializable {

    private static final long serialVersionUID = 244542737342156582L;

    /**
     * 公告类型id
     */
    private Long newsTypeId;

    /**
     * 父级公告类型id，一级公告类型的父级公告类型id为0
     */
    @NotNull(message = "父级公告类型id不能为空")
    @Range(min = 0, message = "parentId is illegal")
    private Long parentId;

}

