package com.digiwin.athena.semc.dto.open;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 应用或者作业跳转信息-查询实体
 * @Author jf gui
 */
@Data
public class AppJobUrlReq {

    /**
     * SSO配置中的appCode
     */
    @NotBlank(message = "应用代号不能为空")
    private String appCode;

    /**
     * 数据来源：
     * ● 1：B/S应用配置
     * ● 2：C/S应用配置
     * ● 3：内置应用
     */
    @NotNull(message = "应用来源不能为空")
    private Integer dataSource;

    /**
     * 作业编号
     */
    private String jobCode;

    private Boolean addAuthCode;

}
