package com.digiwin.athena.semc.dto.open;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 三方待办 查询实体
 *
 * @author jf gui
 */
@Data
public class SystemToDoReq {

    /**
     * SSO配置中的appCode
     */
    private String appCode;

    /**
     * SSO配置中的appId
     */
    private String appId;

    /**
     * 数据源ID
     */
    private Long id;
    /**
     * 查询条件
      */
    private String qryCondition;

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @NotNull(message = "每页数量不能为空")
    private Integer pageSize;

}
