package com.digiwin.athena.semc.dto.portal;


import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


/**
 * 作业集成-作业同步入参
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JobSyncReq implements Serializable  {

    /**
     * 加密后的参数，将入参进行AES加密传输
     */
    private String bodyJsonStr;

    /**
     * 应用code，SSO配置-B/S手工配置或者C/S手工配置中的应用Id值
     */
    private String appIdCode;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    private String appId;

    /**
     * 同步类型：0:新增、1：修改、2：删除
     */
    private Integer syncType;

    /**
     * 同步类型：0:全量方式，1：增量方式
     */
    private int syncModel;

    /**
     * 作业信息集合，最大支持5000
     */
    private List<SyncJobInfo> jobList;

}
