package com.digiwin.athena.semc.dto.portal;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 查询组件列表 请求实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KnowledgeApplicationListReq implements Serializable  {

    @NotNull(message = "page number cannot be empty")
    private Integer pageNum;

    @NotNull(message = "page size cannot be empty")
    private Integer pageSize;

    /**
     * 支持知识库名称与id模糊查询
     * */
    private String knowledge;
    /**
     * 支持应用名称与id模糊查询
     * */
    private String application;

    /**
     * 是否启用 0 未启用，1启用
     * */
    private Integer isEnable;

    private String tenantId;


}
