package com.digiwin.athena.semc.dto.portal;


import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.Label;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 标签列表返回实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@AutoMapper(target = Label.class)
public class LabelResp extends BaseEntity<Label> implements Serializable  {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 系统标识 0:默认 1:敏态 2：稳态
     */
    private Integer systemFlag;

    /**
     * 组件唯一标识
     */
    private String labelKey;

    /**
     * 组件名称
     */
    private String labelName;

    /**
     * 移入的图片url
     */
    private String inPicUrl;

    /**
     * 移出的图片url
     */
    private String outPicUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 生效状态 0:无效 1:有效
     */
    private Integer validStatus;
}
