package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据源-统计分类对象
 *
 * @author sungqz
 * @since 2025-02-24
 */
@Data
public class LabelSystemCountDataDTO implements Serializable {

    private static final long serialVersionUID = -8467684328248471462L;

    /**
     * 统计分类下类型code
     */
    @NotBlank(message = "the contentCode cannot be empty")
    private String contentCode;

    /**
     * 是否选中标识 0：否 1：是
     */
    @Range(min = 0, max = 1, message = "the selectedFlag is illegal")
    private Integer selectedFlag = 0;

    /**
     * 跳转链接
     */
    private String contentLink;

    /**
     * 配置的作业信息
     */
    @Valid
    private JobInfo jobInfo;

    /**
     * 作业信息
     */
    @Data
    public static class JobInfo {

        /**
         * 应用编码
         */
        private String appPrimaryId;

        /**
         * 源应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口 5:虚拟应用
         */
        @Range(min = 1, max = 5, message = "the dataType is illegal")
        private Integer dataType;

        /**
         * 是否需要自定义作业（0：不需要；1：需要）
         */
        @Range(min = 0, max = 1, message = "the isJob is illegal")
        private Integer isJob = 0;

        /**
         * 作业code
         */
        private String workCode;

        /**
         * 作业回调地址
         */
        @Length(max = 500, message = "callBackUrl should be within 500 characters in length")
        private String callBackUrl;
    }
}