package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-01-24 17:14
 * Description:
 */
@Data
public class LabelSystemCustomQueryReq {

    @NotNull(message = "page number cannot be empty")
    private Integer pageNum;

    @NotNull(message = "page size cannot be empty")
    private Integer pageSize;

    /**
     *  是否门户布局(0: 否，1:是)
     */
    @NotNull(message = "portal layout query cannot be empty")
    private Integer isLayout;


    private QueryCondition queryCondition;

    /**
     * 客户端类型
     */
    private Integer clientType;

    @Data
    public static class QueryCondition {

        /**
         * 自定义组件名称-中文
         */
        private String nameZh;

        /**
         * 状态
         */
        private Integer validStatus;

        /**
         * 组件分类（ 3-自定义组件-作业集成、4-自定义组件-应用集成、7-自定义组件-业务待办 8-自定义组件-内嵌网页 9-自定义组件-报表）
         */
        private List<Integer> dataCategory;

        /**
         * 多选应用
         */
        private List<AppLinkDTO> appCodeList;

        /**
         * 应用作业账套
         */
        private List<String> accountIds;

        private Integer source;

    }
}
