package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;

import org.hibernate.validator.constraints.Length;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Data;

/**
 * @author CR-7
 * create: 2024-01-25 10:34
 * Description:
 */
@Data
@AutoMappers({
        @AutoMapper(target = LabelSystemCustom.class),
        @AutoMapper(target = TemplateSystemCustom.class)
})
public class LabelSystemCustomSaveReq {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 自定义组件名称-中文
     */
    @NotBlank(message = "custom component name cannot be empty")
    @Length(max = 40, min = 1, message = "长度40个字符以内")
    private String nameZh;

    /**
     * 自定义组件名称-英文
     */
  //  @NotBlank(message = "custom component us name cannot be empty")
    private String nameUs;

    /**
     * 极简门户图标
     */
   // @NotBlank(message = "icon cannot be empty")
    private String icon;

    /**
     * 经典门户图标
     */
    private String classicsIcon;


    /**
     * 组件分类（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页）
     */
    @NotNull(message = "component classification cannot be empty")
    private Integer dataCategory;

    /**
     * 内嵌网页-组件类型 链接地址
     */
    private String linkUrl;

    /**
     * 内嵌网页-组件类型 链接配置
     */
    private List<LabelSystemLinkParamDTO> linkParamList;

    /**
     * 展示方式（ 0：文本列表、1：应用、2：应用作业）
     */
    private Integer showType;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;


    /**
     * 备注
     */
    private String remark;
    /**
     * 更新人
     */
    private String modifyUserId;

    /**
     * 更新时间
     */
    private String modifyTime;


    private List<DataSourceInfo> dataSourceInfo;

    /**
     *
     */
    private Integer clientType;



    @Data
    @AutoMappers({
            @AutoMapper(target = LabelSystemSource.class),
            @AutoMapper(target = TemplateSystemSource.class)
    })
    public static class DataSourceInfo {

        /**
         * 数据源ID
         */
        private Long dataId;

        /**
         * 组件ID
         */
        private Long systemId;

        /**
         * 组件来源（ 0：自定义组件、1：预设组件）
         */
        private Integer componentSource;

    }
}
