package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;

import java.io.Serializable;

import javax.validation.constraints.Size;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Data;

/**
 * 数据源表实体
 */
@Data
@AutoMappers({
        @AutoMapper(target = LabelSystemData.class),
        @AutoMapper(target = TemplateSystemData.class)
})
public class LabelSystemDataDto  implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * 数据源备注
     */
    private String remark;

    /**
     * 数据源分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计类型
     */
    private Integer dataCategory;

    /**
     * 源应用来源（ 1：BS、2：CS、3：平台预设、4：雅典娜应用）
     */
    private Integer dataType;

    /**
     * 应用id
     */
    private String appId;


    /**
     * 应用秘钥
     */
    private String appSecret;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    private Integer dataModel;

    /**
     * 作业code
     */
    private String workCode;

    /**
     * 地中台系统名称
     */
    private String middleSystemName;

    /**
     * 地中台系统uid
     */
    private String middleSystemUid;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 三方应用接口地址
     */
    private String restUrl;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 租户id
     */
    private String tenantId;


    /**
     * 三方应用对应鼎捷云的应用appId
     */
    private String appName;

    /**
     * 三方应用appToken
     */
    private String appToken;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户 3:外链模式
     */
    private Integer userBindFlag;

    /**
     * 协议类型：1:OAuth2.0 2:CAS
     */
    private Integer protocolType;

    /**
     * CAS服务器地址
     */
    @Size(max = 200, message = "CAS服务器地址的长度不能超过200")
    private String casServerUrl;

    /**
     * 统计组件的类型code值
     */
    private String countCode;

    /**
     * 统计组件的类型的名称code
     */
    private String countContentCode;

}