package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;

import java.util.List;

import javax.validation.constraints.NotNull;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Data;

/**
 * @author CR-7
 * create: 2024-01-24 13:53
 * Description:
 */
@Data
public class LabelSystemDataSourceUpdateReq {

    private List<DataSourceInfo> dataSourceInfo;


    @Data
    @AutoMappers({
            @AutoMapper(target = LabelSystemSource.class),
            @AutoMapper(target = TemplateSystemSource.class)
    })
    public static class DataSourceInfo{
        /**
         *  数据源ID
         */
        private Long dataId;

        /**
         *  组件ID
         */
        @NotNull(message = "systemId cannot be empty")
        private Long systemId;

        /**
         *  组件来源（ 0：自定义组件、1：预设组件）
         */
        @NotNull(message = "componentSource cannot be empty")
        private Integer componentSource;
    }

}
