package com.digiwin.athena.semc.dto.portal;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-01-23 15:32
 * Description:
 */
@Data
public class LabelSystemPreQueryReq {


    @NotNull(message = "page number cannot be empty")
    private Integer pageNum;

    @NotNull(message = "page size cannot be empty")
    private Integer pageSize;

    /**
     *  是否门户布局(0: 否，1:是)
     */
    @NotNull(message = "portal layout query cannot be empty")
    private Integer isLayout;


    /**
     * PC端：0，移动端：1
     */
    private Integer clientType;

    private QueryCondition queryCondition;

    @Data
    public static class QueryCondition {

        /**
         * 组件预设名称
         */
        private String name;

        /**
         * 状态 有效状态 0:无效 1:有效
         */
        private Integer validStatus;

        /**
         * 组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件；）
         */
        private List<Integer> dataCategory;
    }
}
