package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 三方报表/三方待办 查询实体
 *
 */
@Data
public class LabelSystemPreReq {

    /**
     * 数据源id
     */
    @NotNull(message = "数据源ID不能为空")
    private Long id;


    /**
     * 查询条件
      */
    private String qryCondition;

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @NotNull(message = "每页数量不能为空")
    private Integer pageSize;

}
