package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.Logo;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
/**
 * 企业标识设置
 */
@Data
@AutoMapper(target = Logo.class)
public class LogoReq implements  Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 企业登录后logo图片ID,简体
     */
    private String loginPicId;

    /**
     * 企业登录后logo图片ID,繁体
     */
    private String loginPicIdTw;

    /**
     * 企业登录后logo图片ID,英文
     */
    private String loginPicIdUs;

    /**
     * 网页标题图片ID,简体
     */
    private String titlePicId;

    /**
     * 网页标题图片ID,繁体
     */
    private String titlePicIdTw;

    /**
     * 网页标题图片ID,英文
     */
    private String titlePicIdUs;


    /**
     * 企业登录后logo图片URL,简体
     */
    private String loginPicUrl;

    /**
     * 企业登录后logo图片URL,繁体
     */
    private String loginPicUrlTw;

    /**
     * 企业登录后logo图片URL,英文
     */
    private String loginPicUrlUs;

    /**
     * 网页标题图片URL,简体
     */
    private String titlePicUrl;

    /**
     * 网页标题图片URL,繁体
     */
    private String titlePicUrlTw;

    /**
     * 网页标题图片URL,英文
     */
    private String titlePicUrlUs;

    /**
     * 租户id
     */
    private String tenantId;


    /**
     * 官网地址
     */
    private String webSiteAddr;

    /**
     * 官网地址,繁体
     */
    private String webSiteAddrTw;

    /**
     * 官网地址,英文
     */
    private String webSiteAddrUs;


    /**
     * 简体网页标题
     */
    private String title;

    /**
     * 网页标题-繁体
     */
    private String titleTw;

    /**
     * 网页标题-英文
     */
    private String titleUs;


    /**
     *  启用点击logo跳转官网状态（0：未启用；1：启用）-简体
     */
    private Integer jumpStatus;


    /**
     * 启用点击logo跳转官网状态（0：未启用；1：启用）-繁体
     */
    private Integer jumpStatusTw;


    /**
     *  启用点击logo跳转官网状态（0：未启用；1：启用）-英文
     */
    private Integer jumpStatusUs;


    /**
     * 语言 0:简体 1:繁体 2:英文
     */
    private Integer language;


}