package com.digiwin.athena.semc.dto.portal;

import lombok.Data;

import java.io.Serializable;

/**
*   门户中轮播图的图片
 */

@Data
public class PortalContentCarouselImage implements Serializable {


    /**
     * 图片类型（0：模板库选择、1：本地上传）
     */
    private Integer imgType;

    /**
     * 模板库图标或者图片ID
     */
    private String contentIcon;

    /**
     * 图片地址
     */
    private String  imageUrl;

    /**
    * 一级跳转类型（0-常用功能；10-新闻公告；13-应用；14-作业；15-业务待办；16-自定义链接）
    */
    private Integer jumpType;

    /**
    * 二级目标（1-待办；2-友情链接；3-消息；4-作业工作台；5-常用；6-收藏；7-升级说明；8-行事历；9-全局搜索；11-单条公告；12-公告分类；）
    */
    private Integer jumpTarget;

    /**
     * 跳转值，如果是多个值，以逗号分隔，例如公告类型
     */
    private String jumpValue;

    /**
     * 回显名称
     */
    private String jumpName;

    /**
     * 是否需要校验权限（0：不需要，都有权限；1：需要）
     */
    private Integer isNeedCheckPerm;

    /**
     * 部件来源 0：租户部件 1：isv部件
     */
    private Integer jumpSource;

    /**
     * 文件ID
     */
    private String fileId;
}
