package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


@Data
public class PortalInfoQueryReq implements Serializable {

    /**
     * 门户端 PC端：0，移动端：1
     */
    @NotNull(message = "clientType cannot be empty")
    @Range(min = 0, max = 1, message = "clientType is illegal")
    private Integer clientType;

    /**
     * 当前页
     */
    @NotNull(message = "page number cannot be empty")
    private Integer pageNum;

    /**
     * 页大小
     */
    @NotNull(message = "page size cannot be empty")
    private Integer pageSize;

    /**
     * 数据版本，如：1.0、2.0
     */
    private String version;

    /**
     * 名称
     */
    private String name;

    /**
     * 组件状态（0：未发布；1：已发布）
     */
    private Integer status;

    /**
     * 1：创建时间；2：更新时间
     */
    private Integer sortType;

    /**
     * desc/asc
     */
    private String orderBy;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 门户ID集合
     */
    private List<Long> idList;

    /**
     * 移动门户ID集合
     */
    private List<MobileIdReq> mobileIdReqList;

    /**
     * 更新日期
     */
    protected String modifyTime;

    /**
     * 更新者登录账号
     */
    protected String modifyUserId;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;

    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    private Integer portalType;

    @Data
    public static class MobileIdReq {

        /**
         * 门户ID
         */
        private Long id;

        /**
         * 是否是老移动门户 true：是 false：否
         */
        private Boolean oldPortalFlag = false;
    }
}
