package com.digiwin.athena.semc.dto.portal;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-02-01 19:14
 * Description:
 */
@Data
public class PortalLayoutCustomReq {


    @Valid
    private List<PortalLayoutCustomInfo> portalLayoutInfo;


    @Data
    public static class PortalLayoutCustomInfo {


        /**
         * 门户布局主键id
         */
        private Long portalLayoutId;

        /**
         * 组件主键id
         */
        private Long id;

        /**
         * 标签位置
         */
        @NotNull(message = "the label position cannot be empty")
        private Integer labelIndex;

        /**
         *  组件来源（ 0：自定义组件、1：预设组件）
         */
        private Integer componentSource;
    }

}
