package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import net.sf.json.JSONObject;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Description: 预装应用更新配置DTO
 * @CreateTime: 2023/1/29 10:53
 * @Author: sunyfa
 */
@Data
public class PreinstalledApplicationConfigUpdateDto {
    /**
     * 应用类型
     */
    @NotBlank(message = "the applicationType can not be empty")
    private String applicationType;

    /**
     * 预装应用id
     */
    @NotEmpty(message = "the preinstalledApplicationId can not be empty")
    private List<Long> preinstalledApplicationId;

    /**
     * 配置信息
     */
    @Valid
    private JSONObject config;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户 3：外链模式
     */
    private Integer userBindFlag;

    /**
     * 状态：0失效；1生效
     */
    private Integer status;
}
