package com.digiwin.athena.semc.dto.portal;

import lombok.*;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * 查询业务待办分组条件 请求实体
 *
 * @author sungqz
 * @since 2024-07-31
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryGroupReq implements Serializable {

    private static final long serialVersionUID = -5078948447176163555L;

    // ------ 查询小AI分组条件值请求入参
    /**
     * 分组条件code
     */
    private String groupCode;

    // ------ 以下是查询三方应用分组条件请求参数
    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    @Range(min = 0, max = 1, message = "the data_model is illegal")
    private Integer dataModel;

    /**
     * 地中台系统名称
     */
    @Length(max = 100, message = "the length of middle system name cannot over 200")
    private String middleSystemName;

    /**
     * 地中台系统uid
     */
    @Length(max = 100, message = "the length of middle system uid cannot over 200")
    private String middleSystemUid;

    /**
     * 三方应用接口地址
     */
    @Length(max = 500, message = "the length of the restUrl cannot over 500")
    private String restUrl;

    // ----- 前台查询待办数量的请求参数
    /**
     * 组件id
     */
    private Long systemId;

    /**
     * 客户端id
     */
    private String clientId;
}