package com.digiwin.athena.semc.dto.portal;

import lombok.*;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 查询导入记录
 * @createDate: 2023/8/16
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryImportRecordReq implements Serializable {

    /**
     * 操作人工号
     */
    private List<String> userIdList;

    /**
     * 查询开始时间
     */
    private String startTime;

    /**
     * 查询结束时间
     */
    private String endTime;

    /**
     * 当前页
     */
    @NotNull(message = "the pageNum cannot be null")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @NotNull(message = "the pageSize cannot be null")
    private Integer pageSize;


    /**
     * 操作人名称或者用户ID
     */
    private String userIdName;

}