package com.digiwin.athena.semc.dto.portal;


import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


/**
 * 查询数据源、组件等 请求实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryLabelSystemReq implements Serializable {

    /**
     * 数据源名称/预设组件名称/自定义组件名称
     */
    private String name;
    /**
     * 源应用
     */
    private List<AppLinkDTO> appCodeList;

    /**
     * 分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * 3-自定义组件-作业集成、4-自定义组件-应用集成、5-预设组件-固定组件、6-自定义组件-统计、7-自定义组件-业务待办、9、自定义组件-报表
     */
    private List<Integer> dataCategoryList;

    /**
     * 数据源ID/预设组件ID/自定义组件ID
     */
    private Long id;

    /**
     * 生效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    private Integer dataType;
    /**
     * 数据源IDS
     */
    private List<Long> ids;

    /**
     *  页码
     */
    private Integer pageNum;

    /**
     * 每页数量
     */
    private Integer pageSize;


    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用
     */
    private Integer dataSource;

    /**
     * 作业名称或者code
     */
    private String jobCodeName;

    /**
     * 0:为web端 1：移动端 null或者不传则为查询全部
     */
    private Integer type;

    private List<String> accountIds;
}
