package com.digiwin.athena.semc.dto.portal;

import lombok.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 查询报表列表 请求对象
 * @createDate: 2023/8/16
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryReportReq implements Serializable {

    /**
     * 关键字不能为空
     */
    @Valid
    @NotEmpty(message = "{NotEmpty.QueryReportReq.keyList}")
    @Size(max = 10, message = "{Size.QueryReportReq.keyList}")
    private List<String> keyList;
}