package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: sungqz
 * @CreateTime: 2023/5/12
 * @Description: 报表查询请求参数
 * @Version: 1.0
 */
@Data
public class ReportPageQueryReq {
    // 查询条件
    private String qryCondition;

    // 页码
    @NotNull(message = "页码不能为空")
    private Integer pageNum;

    // 每页数量
    @NotNull(message = "每页数量不能为空")
    private Integer pageSize;

    // 地中台系统信息
    @Valid
    @NotNull(message = "地中台系统信息不能为空")
    private List<EaiSysInfo> eaiSysInfoList;

    @Data
    public static class EaiSysInfo {
        /**
         * 地中台系统名称
         */
        @NotBlank(message = "地中台系统名称不能为空")
        private String eaiSysName;

        /**
         * 地中台系统UID
         */
        @NotBlank(message = "地中台UID不能为空")
        private String eaiSysUid;

        /**
         * 系统注册的token
         */
        @NotBlank(message = "AppToken不能为空")
        private String appToken;

        /**
         * 归户模式 0:自动归户 1：手动归户 2：无需归户
         */
        @NotNull(message = "规模模式不能为空")
        @Range(max = 2, message = "归户模式不合法")
        private Integer userBindFlag;
    }
}
