package com.digiwin.athena.semc.dto.portal;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 帆软报表链接后缀配置
 * @createDate: 2023/7/25
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveReportUrlParamReq implements Serializable {
    /**
     * 单条或者多条报表主键
     */
    @Valid
    @NotEmpty(message = "{NotNull.Folder.id}")
    private List<Long> ids;

    /**
     * 是否配置人员 0:否; 1:是
     */
    @Range(min = 0, max = 1, message = "{Range.FineReportVo.userConfigFlag}")
    private Integer userConfigFlag;

    /**
     * 配置的部门标识 1：一级部门 2：二级部门 3：三级部门
     */
    @Range(min = 1, max = 3, message = "{Range.FineReportVo.departmentConfigFlag}")
    private Integer departmentConfigFlag;

    /**
     * 配置的工厂名称
     */
    private String factoryConfigName;
}