package com.digiwin.athena.semc.dto.portal;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


/**
 * 配置组件应用系统 请求实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SaveSystemReq implements Serializable  {

    /**
     * 组件id
     */
    private Long labelId;

    /**
     * 页签标识
     */
    private String tabFlag;

    /**
     * 新增的系统列表
     */
    private List<SystemReq> addSystemList;

    /**
     * 更新的系统列表
     */
    private List<SystemReq> updateSystemList;

    /**
     * 删除的系统列表
     */
    private List<SystemReq> delSystemList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    static
    public class SystemReq {

        /**
         * 主键id
         */
        private Long id;

        /**
         * 系统名称
         */
        private String systemName;

        /**
         * 地中台产品名称
         */
        private String middleSystemName;

        /**
         * 地中台产品UID
         */
        private String middleSystemUid;
    }
}
