package com.digiwin.athena.semc.dto.portal;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


@Data
public class TemplateQueryReq implements Serializable {


    @NotNull(message = "page number cannot be empty")
    private Integer pageNum;

    @NotNull(message = "page size cannot be empty")
    private Integer pageSize;


    /**
     * 租户名称或者ID
     */
    private String tenantNameId;


    /**
     * 关联关系id
     */
    private Long id;



    /**
     * 分组id
     */
    private Long groupId;


    /**
     * 模版编号
     */
    private String templateNo;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 模版类型（0：经典门户、1：作业工作台、2：自定义菜单）
     */
    private Integer templateType;

    /**
     * 租户id
     */
    private String tenantId;


    /**
     *
     */
    private List<Long> idList;

    /**
     *有效状态 0:无效 1:有效
     */
    private Integer validStatus;


    /**
     * 创建人名称或者ID
     */
    private String createNameId;


    /**
     * 状态（0：未发布；1：已发布）
     */
    private Integer status;

    /**
     * 名称或者id 搜索
     */
    private String subUserNameId;
}
