package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.TodoField;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * 待办列表标题实体类
 */
@Data
@AutoMapper(target = TodoField.class)
public class TodoFieldDto   implements Serializable {

    private static final long serialVersionUID = 7007705555722457L;

    /**
     * 显示名称
     */
    @JsonProperty(value = "display_name")
    private String displayName;

    /**
     * 显示顺序
     */
    @JsonProperty(value = "display_order")
    private Integer displayOrder;

    /**
     * 显示字段绑定数据的字段
     */
    @JsonProperty(value = "binding_data_key")
    private String bindingDataKey;

}