package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.TodoList;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * 待办列表(TodoList)实体类
 *
 */
@Data
@AutoMapper(target = TodoList.class)
public class TodoListDto  implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 外部系统待办唯一标识
     */
    @JsonProperty(value = "to_do_id")
    private String toDoId;

    /**
     * PC待办跳转URL
     */
    @JsonProperty(value = "to_do_url")
    private String toDoUrl;


    /**
     * APP待办跳转URL
     */
    @JsonProperty(value = "to_do_mobile_url")
    private String toDoMobileUrl;

    /**
     * 待办数据
     */
    @JsonProperty(value = "to_do_data")
    private String toDoData;

    /**
     * 待办人
     */
    @JsonProperty(value = "to_do_owner")
    private String toDoOwner;

    /**
     * 移动显示的主标题
     */
    @JsonProperty(value = "mobile_main_title")
    private String mobileMainTitle;
    /**
     * 移动显示的副标题
     */
    @JsonProperty(value = "mobile_sub_title")
    private String mobileSubTitle;
    /**
     * 移动显示的文本
     */
    @JsonProperty(value = "mobile_label")
    private String mobileLabel;

    /**
     * 账套id
     */
    @JsonProperty(value = "account_id")
    private String accountId;

    /**
     * 账套名称
     */
    @JsonProperty(value = "account_name")
    private String accountName;
}
