package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/15 10:25
 * @Description: 待办列表查询请求参数
 * @Version: 1.0
 */
@Data
public class TodoListReq {
    // 查询条件
    private String qryCondition;

    // 地中台系统信息
    @Valid
    @NotNull(message = "地中台系统信息不能为空")
    private List<EaiSys> eaiSysList;

    @Data
    public static class EaiSys {
        /**
         * 地中台系统名称
         */
        @NotBlank(message = "地中台系统名称不能为空")
        private String eaiSysName;

        /**
         * 地中台系统UID
         */
        @NotBlank(message = "地中台UID不能为空")
        private String eaiSysUid;

        /**
         * 系统注册的token
         */
        private String appToken;

        /**
         * 注册的系统名称
         */
        @NotBlank(message = "注册的系统名称不能为空")
        private String appName;

        /**
         * 归户模式 0:自动归户 1：手动归户 2：无需归户
         */
        @NotNull(message = "归户模式不能为空")
        @Range(max = 2, message = "归户模式不合法")
        private Integer userBindFlag;
    }
}
