package com.digiwin.athena.semc.dto.portal;

import com.digiwin.athena.semc.entity.portal.TodoField;
import com.digiwin.athena.semc.entity.portal.TodoList;
import lombok.Data;

import java.util.List;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/15 10:25
 * @Description: 待办列表查询请求参数
 * @Version: 1.0
 */
@Data
public class TodoListResp {
    /**
     * 待办显示数据
     */
    private List<TodoList> todoList;

    /**
     * 待办显示字段
     */
    private List<TodoField> todoFieldList;

    /**
     * 待办总未读数量
     */
    private Integer totalUnreadCount = 0;

    /**
     * 是否显示红点
     */
    private boolean isRed = false;

    /**
     * 查询结果
     */
    private String resultCode = "200";

    /**
     * 总记录条数
     */
    private Integer totalResults;
}
