package com.digiwin.athena.semc.dto.portal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 待办接收实体类
 *
 */
@Data
public class TodoReceiveDto implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 应用code，SSO配置-B/S手工配置或者C/S手工配置中的应用id值
     */
    @JsonProperty(value = "app_id_code")
    private String appIdCode;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @JsonProperty(value = "app_code")
    private String appCode;

    /**
     *  待办数据集合
     */
    @JsonProperty(value = "to_do_list")
    private List<TodoListDto> toDoList;

    /**
     * 待办展示列表标题
     */
    @JsonProperty(value = "display_field_list")
    private List<TodoFieldDto> displayFieldList;



}
