package com.digiwin.athena.semc.dto.portal;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户组件权限导入请求入参
 *
 * @author sunqgz
 * @since 2024-06-04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UserLabelAuthReq implements Serializable {

    private static final long serialVersionUID = 8916372204214062718L;

    /**
     * 文件id
     */
    @NotBlank(message = "文件id不能为空")
    private String fileId;

    /**
     * 文件名称
     */
    @NotBlank(message = "文件名称不能为空")
    private String fileName;
}

