package com.digiwin.athena.semc.dto.portal;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 门户访问记录 请求对象
 *
 * @author sungqz
 * @since 2025-09-18
 */
@Data
public class VisitPortalReq {

    /**
     * isv设计时门户id
     */
    @NotBlank(message = "designerPortalId can not be empty")
    private Long designerPortalId;

    /**
     * 客户端类型 0：PC端 1：移动端
     */
    @NotNull(message = "clientType can not be null")
    @Range(min = 0, max = 1, message = "clientType is illegal")
    private Integer clientType;

    /**
     * 访问类型，0：访问首页门户 1：访问管理后台门户
     */
    @NotNull(message = "visitType can not be null")
    @Range(min = 0, max = 1, message = "visitType is illegal")
    private Integer visitType;
}
