package com.digiwin.athena.semc.entity.applink;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;

/**
 *  @date 2022/12/23
 */
@Data
@Document(collection = "app_link_access")
@CompoundIndexes({
        @CompoundIndex(name = "tenant_user_app_date_idx",
                def = "{'tenantId':1,'userId':1,'appId':1,'accessDate':-1}")})
public class AppLinkAccessDO {
    @Id
    private String id;

    private String tenantId;

    private String userId;

    private String appId;

    private LocalDateTime accessDate;

}
