package com.digiwin.athena.semc.entity.applink;

import com.digiwin.athena.semc.vo.common.BizObjAuthRelVo;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 *  @date 2022/12/23
 */
@Data
public class AppLinkDTO {

    /**
     * 应用主键id
     */
    private String primaryId;

    /**
     * 应用id，拼接前缀的应用code
     */
    private String id;

    /**
     * 应用code
     */
    private String code;

    /**
     * 应用名称
     */
    private String name;

    /**
     * 应用icon
     */
    private String icon;

    /**
     * 应用描述
     */
    private String desc;

    /**
     * 应用类型 1:b/s应用 2:c/s应用 3:特殊应用 4:IAM应用 5:虚拟应用
     */
    private String type;

    /**
     * 应用类型 1:b/s应用 2:c/s应用
     */
    private Integer systemType;

    /**
     * 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用 5:虚拟应用
     */
    private Integer dataSource;

    /**
     * 云端访问地址
     */
    private String cloudwebsite;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 移动端
     */
    private String mobileCallBackUrl;

    /**
     * 新增的应用id
     */
    private String applicationAppId;

    /**
     * 如果appToken不为空，则需要前端额外拼接在url后
     * 需要额外拼接的内容总共有userToken，dwLang，routerKey和appToken
     */
    private String appToken;

    /**
     * 入口预设应用表中appId
     */
    private String appId;

    /**
     * 应用秘钥
     */
    private String appSecret;


    /**
     * 产品代号
     */
    private String productCode;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    private Integer protocolType;

    private String casServerUrl;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;


    /**
     * 是否需要实时获取sso地址，0：不需要；1：需要
     */
    private Integer isNeedSsoUrl=0;

    /**
     * 是否需要获取授权码 0:否 1:是
     */
    private Integer needAuthCodeFlag;


    /**
     * 是否有权限 false:无 true：有
     */
    Boolean isHavePerm = Boolean.TRUE;

    /**
     * 展示类型，0：web，1：app
     */
    private  int showType;


    /**
     * 授权组织
     */
    @Valid
    private List<BizObjAuthRelVo> org;

    /**
     * 授权角色
     */
    @Valid
    private List<BizObjAuthRelVo> role;

    /**
     * 授权用户
     */
    @Valid
    private List<BizObjAuthRelVo> user;
}
