package com.digiwin.athena.semc.entity.base;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * ClassName: BaseEntity
 * Description: 实体类基类
 * Date: 2022年11月10日
 * @author sungqz
 */
@Data
@SuppressWarnings("rawtypes")
public abstract class BaseEntity<T> {

    private static final long serialVersionUID = 1L;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time", fill = FieldFill.INSERT_UPDATE)
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String modifyUserId;

    /**
     * 删除时间
     */
    @TableField(value="del_time")
    protected LocalDateTime delTime;

    /**
     * 删除标记：0有效；1删除
     */
    @TableField(value="del_flag")
    protected Integer delFlag;

    /**
     * 删除者登录账号
     */
    @TableField(value="del_user_id")
    protected String delUserId;
}