package com.digiwin.athena.semc.entity.bench;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 作业工作台
 */
@Data
@TableName(value = "t_job_bench")
public class JobBench extends BaseEntity<JobBench> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台/泳道名称
     */
    @TableField(value="name")
    private String name;

    /**
     * 上级id
     */
    @TableField(value="parent_id")
    private Long parentId;

    /**
     * 模版ID
     */
    @TableField(value="template_id")
    private Long templateId;

    /**
     * 组件展示位置
     */
    @TableField(value="label_index")
    private Integer labelIndex;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 是否需要判断隐藏工作台 false:不需要 true：需要
     */
    @TableField(exist = false)
    private Boolean needDetermineHidden;

    /**
     * 泳道集合
     */
    @TableField(exist = false)
    private List<JobBench> laneList;


    /**
     * 作业集合
     */
    @TableField(exist = false)
    private List<JobBenchCustom> jobList;
}