package com.digiwin.athena.semc.entity.bench;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 工作台组件关系表
 */
@Data
@TableName(value = "t_job_bench_custom")
public class JobBenchCustom extends BaseEntity<JobBenchCustom> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台ID
     */
    @TableField(value="bench_id")
    private Long benchId;


    /**
     * 自定义组件ID
     */
    @TableField(value="system_id")
    private Long systemId;



    /**
     * 组件展示位置
     */
    @TableField(value="label_index")
    private Integer labelIndex;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 自定义组件中文名称
     */
    @TableField(exist = false)
    private String nameZh;


    /**
     * 是否有权限，true：有权限，false：无权限
     */
    @TableField(exist = false)
    private Boolean isPermission;

    /**
     * 组件分类（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办）
     */
    @TableField(exist = false)
    private Integer labelDataCategory;
}