package com.digiwin.athena.semc.entity.bench;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 作业同步记录
 */
@Data
@TableName(value = "t_sync_job_history")
public class SyncJobHistory implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value="app_id")
    private String appId;

    /**
     * 同步类型：0:新增、1：修改、2：删除
     */
    @TableField(value="sync_type")
    private Integer syncType;


    /**
     * 入参
     */
    @TableField(value="req_json")
    private String reqJson;


    /**
     * 出参
     */
    @TableField(value="resp_json")
    private String respJson;


    /**
     * 状态（0:成功，1：失败）
     */
    @TableField(value="sync_status")
    private Integer syncStatus;


    /**
     * 备注
     */
    @TableField(value="remark")
    private Integer remark;


    /**
     * 租户id
     */
    @TableField(value="tenant_id", exist = false)
    private String tenantId;

}