package com.digiwin.athena.semc.entity.bench;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 作业信息同步
 */
@Data
@TableName(value = "t_sync_job_info")
public class SyncJobInfo  implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code，SSO配置-B/S手工配置或者C/S手工配置中的应用Id值
     */
    private String appIdCode;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value="app_id")
    private String appId;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的name值
     */
    @TableField(value="app_name")
    private String appName;

    /**
     * 作业名称
     */
    @TableField(value="job_name")
    private String jobName;

    /**
     * 版本号
     */
    @TableField(value="version")
    private String version;

    /**
     * 作业code
     */
    @TableField(value="job_code")
    private String jobCode;


    /**
     * 作业跳转地址
     */
    @TableField(value="job_url")
    private String jobUrl;

    /**
     * 移动端作业跳转地址
     */
    @TableField(value = "mobile_job_url")
    private String mobileJobUrl;


    /**
     * 备注
     */
    @TableField(value="remark")
    private String remark;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 账套id
     */
    @TableField(value="account_id")
    private String accountId;

    /**
     * 账套id
     */
    @TableField(value="account_name")
    private String accountName;
}