package com.digiwin.athena.semc.entity.bench;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 异构系统作业接入配置表实体类
 *
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_job_config")
public class ThirdJobConfig extends BaseEntity<ThirdJobConfig> implements Serializable {

    private static final long serialVersionUID = 197028986948020865L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用主键id
     */
    @NotBlank(message = "the appPrimaryId cannot be null")
    private String appPrimaryId;


    /**
     * 应用code
     */
    private String appCode;


    /**
     * 应用注册时生成的appId
     */
    private String applicationAppId;

    /**
     * 应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    @NotNull(message = "the appSource cannot be null")
    @Range(min = 1, max = 4, message = "the appSource is illegal")
    private Integer appSource;


    /**
     * 配置描述
     */
    @Length(max = 200, message = "the length of configDesc cannot over 200")
    private String configDesc;


    /**
     * 数据获取方式 1:应用推送数据 2:拉取应用数据
     */
    @NotNull(message = "the dataGetType cannot be null")
    @Range(min = 1, max = 2, message = "the dataGetType is illegal")
    private Integer dataGetType;


    /**
     * 应用接入模式 0:混合云 1:非混合云
     */
    @TableField(value="app_access_model",updateStrategy = FieldStrategy.IGNORED)
    private Integer appAccessModel;

    /**
     * 地中台产品名称
     */
    @TableField(value="middle_system_name",updateStrategy = FieldStrategy.IGNORED)
    private String middleSystemName;

    /**
     * 地中台产品uid
     */
    @TableField(value="middle_system_uid",updateStrategy = FieldStrategy.IGNORED)
    private String middleSystemUid;

    /**
     * 应用域名
     */
    @TableField(value= "`domain`",updateStrategy = FieldStrategy.IGNORED)
    private String domain;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 应用名称
     */
    @TableField(exist = false)
    private String appName;
}

