package com.digiwin.athena.semc.entity.common;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description: 业务授权关系
 * @createDate: 2023/5/26 9:19
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_biz_obj_auth_rel")
public class BizObjAuthRel extends BaseEntity<BizObjAuthRel> implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 业务对象id
     */
    @TableField(value = "biz_obj_id")
    private String bizObjId;

    /**
     * 业务类型：1.帆软报表 2.友情链接应用管理
     */
    @TableField(value = "biz_obj_type")
    private Integer bizObjType;

    /**
     * 业务子类型：1:b/s应用 2:c/s应用 3:预设应用 4:雅典娜应用
     */
    @TableField(value = "biz_obj_sub_type")
    private Integer bizObjSubType;

    /**
     * 权限对象id
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @TableField(value = "auth_type")
    private Integer authType;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;
}