package com.digiwin.athena.semc.entity.common;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description: 业务常用记录表
 * @createDate: 2023/9/11
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_biz_obj_common_use")
public class BizObjCommonUse extends BaseEntity<BizObjCommonUse> implements Serializable {

    private static final long serialVersionUID = -7339463249498368114L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 业务对象id
     */
    @TableField(value = "biz_obj_id")
    private String bizObjId;

    /**
     * 业务类型： 2.友情链接应用管理
     */
    @TableField(value = "biz_obj_type")
    private Integer bizObjType;

    /**
     * 业务子类型：1:b/s应用 2:c/s应用 3:预设应用 4:雅典娜应用
     */
    @TableField(value = "biz_obj_sub_type")
    private Integer bizObjSubType;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}