package com.digiwin.athena.semc.entity.common;

import javax.validation.constraints.Size;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
* 
* @TableName t_company_factory
*/

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName(value = "t_company_factory")
public class CompanyFactory extends BaseEntity<CompanyFactory> implements Serializable {

    /**
    * 主键ID
    */
    @TableId(type = IdType.AUTO)
    @NotNull(message="[主键ID]不能为空")
    private Long id;
    /**
    * 公司别
    */
    @Size(max= 512,message="编码长度不能超过512")
    @Length(max= 512,message="编码长度不能超过512")
    private String company;
    /**
    * c厂别
    */
    @Size(max= 512,message="编码长度不能超过512")
    @Length(max= 512,message="编码长度不能超过512")
    private String factory;
    /**
    * 租户id
    */
    @Size(max= 128,message="编码长度不能超过128")
    @Length(max= 128,message="编码长度不能超过128")
    private String tenantId;


    /***
     * 应用编码
     */
    private String appCode;
}
