package com.digiwin.athena.semc.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 通用目录树对象
 * @createDate: 2023/5/26 9:11
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_folder")
public class Folder extends BaseEntity<Folder> implements Serializable {
    /** 主键 */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 目录名称 */
    @TableField(value = "name")
    private String name;

    /** 父目录标识 */
    @TableField(value = "parent_folder_id", updateStrategy = FieldStrategy.IGNORED)
    private Long parentFolderId;

    /** 目录类型：1.帆软报表目录 */
    @TableField(value = "obj_type")
    private Integer objType;

    /** 描述 */
    @TableField(value = "comments")
    private String comments;

    /** 目录层级 1:一级目录; 2:二级目录 3:三级目录 */
    @TableField(value = "level")
    private Integer level;

    /** 目录路径 */
    @TableField(value = "path_code")
    @JsonIgnore
    private String pathCode;

    /** 目录顺序 */
    @TableField(value = "folder_order")
    private Integer folderOrder;

    @TableField(exist = false)
    private List<Folder> children;
}
