package com.digiwin.athena.semc.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 报表导入记录表
 * @createDate: 2023/8/15
 * @author: sunqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_import_record")
public class ImportRecord extends BaseEntity<ImportRecord> implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 文件id
     */
    @TableField(value = "file_id")
    private String fileId;

    /**
     * 文件名称
     */
    @TableField(value = "file_name")
    private String fileName;

    /**
     * 失败文件id
     */
    @TableField(value = "fail_file_id")
    private String failFileId;

    /**
     * 失败文件名称
     */
    @TableField(value = "fail_file_name")
    private String failFileName;

    /**
     * 失败文件url
     */
    @TableField(value = "fail_file_url")
    private String failFileUrl;

    /**
     * 成功记录数
     */
    @TableField(value = "success_count")
    private Integer successCount;
    /**
     * 失败记录数
     */
    @TableField(value = "fail_count")
    private Integer failCount;

    /**
     * 目录类型：1.帆软报表目录
     */
    @TableField(value = "obj_type")
    private Integer objType;

    /**
     * 创建人姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 租户
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}