package com.digiwin.athena.semc.entity.common;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description: 导入模版
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_import_template")
public class ImportTemplate extends BaseEntity<ImportTemplate> implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 数据源导入模版文件ID
     */
    @TableField(value = "data_file_id")
    private String dataFileId;

    /**
     * 自定义组件导入模版文件ID
     */
    @TableField(value = "custom_file_id")
    private String customFileId;

    /**
     * 工作台导入模版文件ID
     */
    @TableField(value = "bench_file_id")
    private String benchFileId;

    /**
     * 租户
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}