package com.digiwin.athena.semc.entity.device;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author jeff gui
 * @Description 设备信息表实体
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("semc_device_info")
public class DeviceInfo extends BaseEntity<DeviceInfo> implements Serializable {
    /**
     * 主键ID
     */
    @TableId
    private Long id;

    /**
     * 设备ID
     */
    @TableField("device_id")
    private String deviceId;

    /**
     * 上报设备名称
     */
    @TableField("device_name")
    private String deviceName;

    /**
     * 上报终端类型 0:PC端 1：移动端
     */
    @TableField("terminal_type")
    private Integer terminalType;

    /**
     * 设备型号
     */
    @TableField("device_model")
    private String deviceModel;

    /**
     * 硬件UUID
     */
    @TableField("hardware_uuid")
    private String hardwareUuid;

    /**
     * MAC地址
     */
    @TableField("mac_address")
    private String macAddress;

    /**
     * 操作系统类型 Windows, macOS, Linux, iOS, Android, Other
     */
    @TableField("os_type")
    private String osType;

    /**
     * 来源标记：0管理员设置；1用户登陆上报
     */
    @TableField("source")
    private Integer source;

    /**
     * 租户id
     */
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 删除时间
     */
    @TableField(value="del_time", exist = false)
    private LocalDateTime delTime;

    /**
     * 删除标记：0有效；1删除
     */
    @TableField(value="del_flag", exist = false)
    private Integer delFlag;

    /**
     * 删除者登录账号
     */
    @TableField(value="del_user_id", exist = false)
    private String delUserId;
}