package com.digiwin.athena.semc.entity.device;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Author jeff gui
 * @Description 账号绑定设备表实体
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("semc_user_bind_device")
public class UserBindDevice extends BaseEntity<UserBindDevice> implements Serializable {
    /**
     * 主键ID
     */
    @TableId
    private Long id;

    /**
     * 鼎捷云用户ID
     */
    @TableField("user_id")
    private String userId;

    /**
     * 创建者登录名称
     */
    @TableField(value="user_name")
    private String userName;

    /**
     * 租户id
     */
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 设备信息主键ID
     */
    @TableField("device_id")
    private String deviceId;

    /**
     * 有效状态：0有效；1无效
     */
    @TableField("status")
    private Integer status;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    private String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    private String modifyUserName;

}    