package com.digiwin.athena.semc.entity.event;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 事件埋点(TEventTracking)实体类
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_event_tracking")
public class EventTracking implements Serializable {
    private static final long serialVersionUID = -19210737024095755L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 创建日期
     */
    @TableField(value = "create_time")
    protected String createTime;

    /**
     * 事件日期
     */
    @TableField(value = "event_time")
    protected String eventTime;

    /**
     * 事件id
     */
    @TableField(value = "event_id")
    private String eventId;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 用户名称
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 租户名称
     */
    @TableField(value = "tenant_name")
    private String tenantName;

    /**
     * 埋点来源：0-后台；1-app；2-h5
     */
    private Integer source;

    /**
     * 埋点内容
     */
    private String content;
}
